#!/bin/bash

OUTPUT_PATH=$1
if [ -z "${OUTPUT_PATH}" ]; then
  OUTPUT_PATH=~/Desktop/download_history.csv
fi

echo "$(cat << EOF
.headers on
.mode csv
.output ${OUTPUT_PATH}
SELECT address, size, DATETIME(started, 'unixepoch') AS start_time, DATETIME(finished, 'unixepoch') AS finish_time, referrer, destination FROM download;
.quit
EOF
)" | sqlite3 ~/Library/Application\ Support/Progressive\ Downloader\ Data/HistoryDB.pslib
